<?php
class LastTweet{
	private $username;
	private $tweet;

	public function LastTweet($username){
		$this->setUsername($username);
		$this->setLastTweet();
	}

	/*Set Methods*/
	public function setUsername($username){
		$this->username = $username;
	}

	private function setLastTweet(){
		//Using curl 
		$url = 'http://api.twitter.com/1/statuses/user_timeline.json?include_entities=true&include_rts=true&screen_name='.$this->username.'&exclude_replies=true&count=1';
	    $curl = curl_init();
 
    	curl_setopt($curl, CURLOPT_URL, $url);
	    curl_setopt ($curl, CURLOPT_RETURNTRANSFER, 1);
    	curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, 10);
 
	    $json = curl_exec($curl);

    	curl_close($curl);
 		$tweet = json_decode($json, true);

 		if(!$tweet || isset($tweet['errors']))
 			throw new Exception();
 
	    $this->tweet = $tweet;
	}

	/*Return Methods*/
	public function getTweet($what){
		if($what == "text"){
			return $this->make_twitter($this->tweet[0][$what]);
		}else if($what == "created_at"){
			return $this->formatDate($this->tweet[0][$what]);
		}
	}

	/*Aux Methos*/
	private function make_twitter($tweetcontent) {  
  		$tweetcontent = preg_replace("#(^|[\n ])([\w]+?://[\w]+[^ \"\n\r\t< ]*)#", "\\1<a href=\"\\2\" target=\"_blank\">\\2</a>", $tweetcontent);
		$tweetcontent = preg_replace("#(^|[\n ])((www|ftp)\.[^ \"\t\n\r< ]*)#", "\\1<a href=\"http://\\2\" target=\"_blank\">\\2</a>", $tweetcontent);
		$tweetcontent = preg_replace("/@(\w+)/", "<a href=\"http://www.twitter.com/\\1\" target=\"_blank\">@\\1</a>", $tweetcontent);
		$tweetcontent = preg_replace("/#(\w+)/", "<a href=\"http://search.twitter.com/search?q=\\1\" target=\"_blank\">#\\1</a>", $tweetcontent);

		return $tweetcontent; 
	}  

	private function formatDate($tweetdate){
		return date("m/d/y \- g:ia",strtotime($tweetdate));
	}
}
?>